#include "module.h"

#if defined GUI_1CHANNEL_ODC
#include "../gui_1channel_odc.h"
#elif defined GUI_1CHANNEL
#include "../gui_1channel.h"
#elif defined GUI_4CHANNEL
#include "../gui_4channel.h"
#endif

#if defined GUI_1CHANNEL_ODC
EtherCATModule::EtherCATModule (GUI_1channel_ODC& gui) : gui(gui){}
#elif defined GUI_1CHANNEL
EtherCATModule::EtherCATModule (RF_System_1channel& gui) : gui(gui){}
#elif defined GUI_4CHANNEL
EtherCATModule::EtherCATModule (RF_System_4channel& gui) : gui(gui){}
#endif

void EtherCATModule::setEnabled (bool enabled)
{
	if (enabled == this->enabled)
	{
		return;		// No action if already enabled
	}

	if (enabled)
	{

#if defined GUI_1CHANNEL_ODC

		slave = startEtherCATSlaveInNewThread(50);
		in = new VariablesInput(slave);
		out = new VariablesOutput(slave);
		ss = new EtherCATSignalsSlots(*in, *out);

		RF_System_1channel_ODC *rf = gui.RF_system_constructor;

		connect(rf, &RF_System_1channel_ODC::signal_set_generator_ready, ss, &EtherCATSignalsSlots::handler_generator_ready_get);
		connect(rf, &RF_System_1channel_ODC::signal_SGx_communication_working, ss, &EtherCATSignalsSlots::handler_SGx_communication_working_get);
		connect(rf, &RF_System_1channel_ODC::signal_PSU_communication_working, ss, &EtherCATSignalsSlots::handler_PSU_communication_working_get);

		int channel_count = 1;
		for (int i = 0; i < channel_count; i++)
		{
			connect(RF_System::Channels->at(i), &RF_Channel::signal_RF_enable_get, ss, &EtherCATSignalsSlots::handler_RF_enable_get);
			connect(RF_System::Channels->at(i), &RF_Channel::signal_DLL_enable_get, ss, &EtherCATSignalsSlots::handler_DLL_enable_get);
			connect(RF_System::Channels->at(i), &RF_Channel::signal_PWM_settings_get, ss, &EtherCATSignalsSlots::handler_PWM_settings_get);
			connect(RF_System::Channels->at(i), &RF_Channel::signal_power_get, ss, &EtherCATSignalsSlots::handler_power_get);
			connect(RF_System::Channels->at(i), &RF_Channel::signal_PA_power_readings, ss, &EtherCATSignalsSlots::handler_PA_power_readings);
			connect(RF_System::Channels->at(i), &RF_Channel::signal_frequency_get, ss, &EtherCATSignalsSlots::handler_frequency_get);
			connect(RF_System::Channels->at(i), &RF_Channel::signal_clock_source_get, ss, &EtherCATSignalsSlots::handler_get_clock_source);
			connect(RF_System::Channels->at(i), &RF_Channel::signal_SWP_measurements_get, ss, &EtherCATSignalsSlots::handler_SWP_measurement_get);
			connect(RF_System::Channels->at(i), &RF_Channel::signal_SWP_settings_get, ss, &EtherCATSignalsSlots::handler_SWP_settings_get);
			connect(RF_System::Channels->at(i), &RF_Channel::signal_temperature_PA_get, ss, &EtherCATSignalsSlots::handler_temperature_get);
			connect(RF_System::Channels->at(i), &RF_Channel::signal_error_get, ss, &EtherCATSignalsSlots::handler_error_get);
			connect(RF_System::Channels->at(i), &RF_Channel::signal_PSU_IU_reading_get, ss, &EtherCATSignalsSlots::handler_PSU_IU_get);
			connect(RF_System::Channels->at(i), &RF_Channel::signal_PSU_enable_combined_get, ss, &EtherCATSignalsSlots::handler_PSU_enable_combined_get);
			connect(RF_System::Channels->at(i), &RF_Channel::signal_PSU_power_efficiency_get, ss, &EtherCATSignalsSlots::handler_PSU_power_efficiency_get);
			connect(RF_System::Channels->at(i), &RF_Channel::signal_PSU_dissipation_get, ss, &EtherCATSignalsSlots::handler_PSU_dissipation_get);

			// ODC WORKAROUND!!
			connect(ss, &EtherCATSignalsSlots::signal_set_RF_enable, rf, &RF_System_1channel_ODC::set_RF_enable_workaround);
			connect(ss, &EtherCATSignalsSlots::signal_execute_sweep, rf, &RF_System_1channel_ODC::execute_sweep_dBm_workaround);

			connect(ss, &EtherCATSignalsSlots::signal_execute_reset_SGx, RF_System::Channels->at(i), &RF_Channel::Execute_Reset_SGx);
			connect(ss, &EtherCATSignalsSlots::signal_execute_reset_protection, RF_System::Channels->at(i), &RF_Channel::Execute_Reset_Protection);
			connect(ss, &EtherCATSignalsSlots::signal_execute_error_clear, RF_System::Channels->at(i), &RF_Channel::Execute_Error_Clear);
			connect(ss, &EtherCATSignalsSlots::signal_set_DLL_enable, RF_System::Channels->at(i), &RF_Channel::Set_DLL_enable);
			connect(ss, &EtherCATSignalsSlots::signal_set_PWM_enable, RF_System::Channels->at(i), &RF_Channel::Set_PWM_enable);
			connect(ss, &EtherCATSignalsSlots::signal_set_power_control_mode, RF_System::Channels->at(i), &RF_Channel::Set_Power_Control_Mode);

			connect(ss, &EtherCATSignalsSlots::signal_PSU_interlock, rf, &RF_System_1channel_ODC::handler_PSU_interlock_modbus);

			connect(ss, &EtherCATSignalsSlots::signal_set_power_watt, RF_System::Channels->at(i), &RF_Channel::Set_Power_Watt);
			connect(ss, &EtherCATSignalsSlots::signal_set_frequency, RF_System::Channels->at(i), &RF_Channel::Set_Frequency);
			connect(ss, &EtherCATSignalsSlots::signal_set_SWP_frequency_start, RF_System::Channels->at(i), &RF_Channel::Set_SWP_Frequency_Start);
			connect(ss, &EtherCATSignalsSlots::signal_set_SWP_frequency_stop, RF_System::Channels->at(i), &RF_Channel::Set_SWP_Frequency_Stop);
			connect(ss, &EtherCATSignalsSlots::signal_set_SWP_frequency_step, RF_System::Channels->at(i), &RF_Channel::Set_SWP_Frequency_Step);
			connect(ss, &EtherCATSignalsSlots::signal_set_SWP_power, RF_System::Channels->at(i), &RF_Channel::Set_SWP_Power_Watt);
			connect(ss, &EtherCATSignalsSlots::signal_set_DLL_frequency_limit_lower, RF_System::Channels->at(i), &RF_Channel::Set_DLL_Frequency_Lower_Limit);
			connect(ss, &EtherCATSignalsSlots::signal_set_DLL_frequency_limit_upper, RF_System::Channels->at(i), &RF_Channel::Set_DLL_Frequency_Upper_Limit);
			connect(ss, &EtherCATSignalsSlots::signal_set_DLL_frequency_start, RF_System::Channels->at(i), &RF_Channel::Set_DLL_Frequency_Start);
			connect(ss, &EtherCATSignalsSlots::signal_set_DLL_frequency_step, RF_System::Channels->at(i), &RF_Channel::Set_DLL_Frequency_Step);
			connect(ss, &EtherCATSignalsSlots::signal_set_DLL_threshold, RF_System::Channels->at(i), &RF_Channel::Set_DLL_Frequency_Threshold);
			connect(ss, &EtherCATSignalsSlots::signal_set_DLL_delay, RF_System::Channels->at(i), &RF_Channel::Set_DLL_Frequency_Main_Delay);
			connect(ss, &EtherCATSignalsSlots::signal_set_PWM_duty_cycle, RF_System::Channels->at(i), &RF_Channel::Set_PWM_Duty_Cycle_Target);
			connect(ss, &EtherCATSignalsSlots::signal_set_clock_source, RF_System::Channels->at(i), &RF_Channel::Set_Clock_Source);

			connect(ss, &EtherCATSignalsSlots::signal_execute_restart_program, &gui, &GUI_1channel_ODC::handler_execute_restart_program);


			/* Phase control setup */
			/* Internal phase only. Splitter board phase control not supported for the time being. */
			connect(ss, &EtherCATSignalsSlots::signal_set_phase, RF_System::Channels->at(i), &RF_Channel::Set_Phase);
			connect(RF_System::Channels->at(i), &RF_Channel::signal_phase_get, ss, &EtherCATSignalsSlots::handler_get_phase);

//			if (gui.config->get_phase_gain_board_mode() == 0)
//			{
//				connect(ss, &EtherCATSignalsSlots::signal_set_phase, RF_System::Channels->at(i), &RF_Channel::Set_Phase);
//				connect(RF_System::Channels->at(i), &RF_Channel::signal_phase_get, ss, &EtherCATSignalsSlots::handler_get_phase);
//			}
//			else if (gui.config->get_phase_gain_board_mode() == 1)
//			{
//				//
//				// TODO:
//				// Should probably kill this for now
//				//
//				connect(ss, &EtherCATSignalsSlots::signal_set_PGB_phase, RF_System::Channels->at(i), &RF_Channel::Set_PGB_Phase);
//				connect(RF_System::Channels->at(i), &RF_Channel::signal_PGB_phase_get, ss, &EtherCATSignalsSlots::handler_get_PGB_phase);
//			}

			connect(gui.datalogger, &LoggingClass::signal_datalogging_enable, ss, &EtherCATSignalsSlots::handler_datalogging_enable_get);
			connect(gui.datalogger, &LoggingClass::signal_datalogging_storage_sufficient, ss, &EtherCATSignalsSlots::handler_datalogging_storage_sufficient);
		}




#elif defined GUI_4CHANNEL

		slave = startEtherCATSlaveInNewThread(50);
		in = new VariablesInput_4channel(slave);
		out = new VariablesOutput_4channel(slave);
		ss = new EtherCATSignalsSlots_4channel(*in, *out);

		RF_System_4channel *rf = &gui;

		int channel_count = rf->channelCount();
		for (int i = 0; i < channel_count; i++)
		{

			//Gets
			connect(RF_System::Channels->at(i), &RF_Channel::signal_error_get, ss, &EtherCATSignalsSlots_4channel::handler_error_get);
			connect(RF_System::Channels->at(i), &RF_Channel::signal_frequency_get, ss, &EtherCATSignalsSlots_4channel::handler_frequency_get);
			connect(RF_System::Channels->at(i), &RF_Channel::signal_power_get, ss, &EtherCATSignalsSlots_4channel::handler_power_get);
			connect(RF_System::Channels->at(i), &RF_Channel::signal_PA_power_readings, ss, &EtherCATSignalsSlots_4channel::handler_PA_power_readings);
//			connect(RF_System::Channels->at(i), &RF_Channel::signal_phase_get, ss, &EtherCATSignalsSlots_4channel::handler_get_phase);

			connect(RF_System::Channels->at(i), &RF_Channel::signal_VGA_attenuation_get, ss, &EtherCATSignalsSlots_4channel::handler_VGA_attenuation_get);
			connect(RF_System::Channels->at(i), &RF_Channel::signal_IQMod_magnitude_get, ss, &EtherCATSignalsSlots_4channel::handler_IQMod_magnitude_get);

			connect(RF_System::Channels->at(i), &RF_Channel::signal_power_control_mode_get, ss, &EtherCATSignalsSlots_4channel::handler_power_control_mode_get);
			connect(RF_System::Channels->at(i), &RF_Channel::signal_RF_enable_get, ss, &EtherCATSignalsSlots_4channel::handler_RF_enable_get);
			connect(RF_System::Channels->at(i), &RF_Channel::signal_DLL_enable_get, ss, &EtherCATSignalsSlots_4channel::handler_DLL_enable_get);
			connect(RF_System::Channels->at(i), &RF_Channel::signal_SWP_measurements_get, ss, &EtherCATSignalsSlots_4channel::handler_SWP_measurement_get);

			//Sets
			connect(ss, &EtherCATSignalsSlots_4channel::signal_set_frequency, RF_System::Channels->at(i), &RF_Channel::Set_Frequency);
			connect(ss, &EtherCATSignalsSlots_4channel::signal_set_power_watt, RF_System::Channels->at(i), &RF_Channel::Set_Power_Watt);
//			connect(ss, &EtherCATSignalsSlots_4channel::signal_set_phase, RF_System::Channels->at(i), &RF_Channel::Set_Phase);				//Internal phase only. Splitter board phase control not supported for the time being.

			connect(ss, &EtherCATSignalsSlots_4channel::signal_set_VGA_attenuation, RF_System::Channels->at(i), &RF_Channel::Set_VGA_attenuation);
			connect(ss, &EtherCATSignalsSlots_4channel::signal_set_IQMod_magnitude, RF_System::Channels->at(i), &RF_Channel::Set_IQMod_Magnitude);

			connect(ss, &EtherCATSignalsSlots_4channel::signal_execute_error_clear, RF_System::Channels->at(i), &RF_Channel::Execute_Error_Clear);
			connect(ss, &EtherCATSignalsSlots_4channel::signal_execute_sweep, RF_System::Channels->at(i), &RF_Channel::Execute_SWP_dBm2);

			connect(ss, &EtherCATSignalsSlots_4channel::signal_set_power_control_mode, RF_System::Channels->at(i), &RF_Channel::Set_Power_Control_Mode);
			connect(ss, &EtherCATSignalsSlots_4channel::signal_set_RF_enable, RF_System::Channels->at(i), &RF_Channel::Set_RF_enable);
			connect(ss, &EtherCATSignalsSlots_4channel::signal_set_DLL_enable, RF_System::Channels->at(i), &RF_Channel::Set_DLL_enable);

			connect(ss, &EtherCATSignalsSlots_4channel::signal_set_DLL_frequency_limit_lower, RF_System::Channels->at(i), &RF_Channel::Set_DLL_Frequency_Lower_Limit);
			connect(ss, &EtherCATSignalsSlots_4channel::signal_set_DLL_frequency_limit_upper, RF_System::Channels->at(i), &RF_Channel::Set_DLL_Frequency_Upper_Limit);
			connect(ss, &EtherCATSignalsSlots_4channel::signal_set_DLL_frequency_start, RF_System::Channels->at(i), &RF_Channel::Set_DLL_Frequency_Start);
			connect(ss, &EtherCATSignalsSlots_4channel::signal_set_DLL_frequency_step, RF_System::Channels->at(i), &RF_Channel::Set_DLL_Frequency_Step);
			connect(ss, &EtherCATSignalsSlots_4channel::signal_set_DLL_threshold, RF_System::Channels->at(i), &RF_Channel::Set_DLL_Frequency_Threshold);
//			connect(ss, &EtherCATSignalsSlots_4channel::signal_set_DLL_delay, RF_System::Channels->at(i), &RF_Channel::Set_DLL_Frequency_Main_Delay);

			connect(ss, &EtherCATSignalsSlots_4channel::signal_set_SWP_frequency_start, RF_System::Channels->at(i), &RF_Channel::Set_SWP_Frequency_Start);
			connect(ss, &EtherCATSignalsSlots_4channel::signal_set_SWP_frequency_stop, RF_System::Channels->at(i), &RF_Channel::Set_SWP_Frequency_Stop);
			connect(ss, &EtherCATSignalsSlots_4channel::signal_set_SWP_frequency_step, RF_System::Channels->at(i), &RF_Channel::Set_SWP_Frequency_Step);
			connect(ss, &EtherCATSignalsSlots_4channel::signal_set_SWP_power, RF_System::Channels->at(i), &RF_Channel::Set_SWP_Power_Watt);
		}




#elif defined GUI_1CHANNEL

		slave = startEtherCATSlaveInNewThread(50);
		in = new VariablesInput_1channel(slave);
		out = new VariablesOutput_1channel(slave);
		ss = new EtherCATSignalsSlots_1channel(*in, *out);

		RF_System_1channel *rf = &gui;

		connect(rf, &RF_System_1channel::signal_set_generator_ready, ss, &EtherCATSignalsSlots_1channel::handler_generator_ready_get);
		connect(rf, &RF_System_1channel::signal_SGx_communication_working, ss, &EtherCATSignalsSlots_1channel::handler_SGx_communication_working_get);
		connect(rf, &RF_System_1channel::signal_PSU_communication_working, ss, &EtherCATSignalsSlots_1channel::handler_PSU_communication_working_get);

		int channel_count = 1;
		for (int i = 0; i < channel_count; i++)
		{
			connect(RF_System::Channels->at(i), &RF_Channel::signal_RF_enable_get, ss, &EtherCATSignalsSlots_1channel::handler_RF_enable_get);
			connect(RF_System::Channels->at(i), &RF_Channel::signal_DLL_enable_get, ss, &EtherCATSignalsSlots_1channel::handler_DLL_enable_get);
			connect(RF_System::Channels->at(i), &RF_Channel::signal_PWM_settings_get, ss, &EtherCATSignalsSlots_1channel::handler_PWM_settings_get);
			connect(RF_System::Channels->at(i), &RF_Channel::signal_power_get, ss, &EtherCATSignalsSlots_1channel::handler_power_get);
			connect(RF_System::Channels->at(i), &RF_Channel::signal_PA_power_readings, ss, &EtherCATSignalsSlots_1channel::handler_PA_power_readings);
			connect(RF_System::Channels->at(i), &RF_Channel::signal_frequency_get, ss, &EtherCATSignalsSlots_1channel::handler_frequency_get);
			connect(RF_System::Channels->at(i), &RF_Channel::signal_clock_source_get, ss, &EtherCATSignalsSlots_1channel::handler_get_clock_source);
			connect(RF_System::Channels->at(i), &RF_Channel::signal_SWP_measurements_get, ss, &EtherCATSignalsSlots_1channel::handler_SWP_measurement_get);
			connect(RF_System::Channels->at(i), &RF_Channel::signal_SWP_settings_get, ss, &EtherCATSignalsSlots_1channel::handler_SWP_settings_get);
			connect(RF_System::Channels->at(i), &RF_Channel::signal_temperature_PA_get, ss, &EtherCATSignalsSlots_1channel::handler_temperature_get);
			connect(RF_System::Channels->at(i), &RF_Channel::signal_error_get, ss, &EtherCATSignalsSlots_1channel::handler_error_get);
			connect(RF_System::Channels->at(i), &RF_Channel::signal_PSU_IU_reading_get, ss, &EtherCATSignalsSlots_1channel::handler_PSU_IU_get);
			connect(RF_System::Channels->at(i), &RF_Channel::signal_PSU_enable_combined_get, ss, &EtherCATSignalsSlots_1channel::handler_PSU_enable_combined_get);
			connect(RF_System::Channels->at(i), &RF_Channel::signal_PSU_power_efficiency_get, ss, &EtherCATSignalsSlots_1channel::handler_PSU_power_efficiency_get);
			connect(RF_System::Channels->at(i), &RF_Channel::signal_PSU_dissipation_get, ss, &EtherCATSignalsSlots_1channel::handler_PSU_dissipation_get);

			connect(ss, &EtherCATSignalsSlots_1channel::signal_set_RF_enable, RF_System::Channels->at(i), &RF_Channel::Set_RF_enable);
			connect(ss, &EtherCATSignalsSlots_1channel::signal_execute_reset_SGx, RF_System::Channels->at(i), &RF_Channel::Execute_Reset_SGx);
			connect(ss, &EtherCATSignalsSlots_1channel::signal_execute_error_clear, RF_System::Channels->at(i), &RF_Channel::Execute_Error_Clear);
			connect(ss, &EtherCATSignalsSlots_1channel::signal_execute_sweep, RF_System::Channels->at(i), &RF_Channel::Execute_SWP_dBm2);
			connect(ss, &EtherCATSignalsSlots_1channel::signal_set_DLL_enable, RF_System::Channels->at(i), &RF_Channel::Set_DLL_enable);
			connect(ss, &EtherCATSignalsSlots_1channel::signal_set_PWM_enable, RF_System::Channels->at(i), &RF_Channel::Set_PWM_enable);
			connect(ss, &EtherCATSignalsSlots_1channel::signal_set_power_control_mode, RF_System::Channels->at(i), &RF_Channel::Set_Power_Control_Mode);

			connect(ss, &EtherCATSignalsSlots_1channel::signal_set_power_watt, RF_System::Channels->at(i), &RF_Channel::Set_Power_Watt);
			connect(ss, &EtherCATSignalsSlots_1channel::signal_set_frequency, RF_System::Channels->at(i), &RF_Channel::Set_Frequency);
			connect(ss, &EtherCATSignalsSlots_1channel::signal_set_SWP_frequency_start, RF_System::Channels->at(i), &RF_Channel::Set_SWP_Frequency_Start);
			connect(ss, &EtherCATSignalsSlots_1channel::signal_set_SWP_frequency_stop, RF_System::Channels->at(i), &RF_Channel::Set_SWP_Frequency_Stop);
			connect(ss, &EtherCATSignalsSlots_1channel::signal_set_SWP_frequency_step, RF_System::Channels->at(i), &RF_Channel::Set_SWP_Frequency_Step);
			connect(ss, &EtherCATSignalsSlots_1channel::signal_set_SWP_power, RF_System::Channels->at(i), &RF_Channel::Set_SWP_Power_Watt);
			connect(ss, &EtherCATSignalsSlots_1channel::signal_set_DLL_frequency_limit_lower, RF_System::Channels->at(i), &RF_Channel::Set_DLL_Frequency_Lower_Limit);
			connect(ss, &EtherCATSignalsSlots_1channel::signal_set_DLL_frequency_limit_upper, RF_System::Channels->at(i), &RF_Channel::Set_DLL_Frequency_Upper_Limit);
			connect(ss, &EtherCATSignalsSlots_1channel::signal_set_DLL_frequency_start, RF_System::Channels->at(i), &RF_Channel::Set_DLL_Frequency_Start);
			connect(ss, &EtherCATSignalsSlots_1channel::signal_set_DLL_frequency_step, RF_System::Channels->at(i), &RF_Channel::Set_DLL_Frequency_Step);
			connect(ss, &EtherCATSignalsSlots_1channel::signal_set_DLL_threshold, RF_System::Channels->at(i), &RF_Channel::Set_DLL_Frequency_Threshold);
			connect(ss, &EtherCATSignalsSlots_1channel::signal_set_DLL_delay, RF_System::Channels->at(i), &RF_Channel::Set_DLL_Frequency_Main_Delay);
			connect(ss, &EtherCATSignalsSlots_1channel::signal_set_PWM_duty_cycle, RF_System::Channels->at(i), &RF_Channel::Set_PWM_Duty_Cycle_Target);
			connect(ss, &EtherCATSignalsSlots_1channel::signal_set_clock_source, RF_System::Channels->at(i), &RF_Channel::Set_Clock_Source);


			/* Phase control setup */
			/* SGX phase only. Splitter bogard phase control not supported for the time being. */
			connect(ss, &EtherCATSignalsSlots_1channel::signal_set_phase, RF_System::Channels->at(i), &RF_Channel::Set_Phase);
			connect(RF_System::Channels->at(i), &RF_Channel::signal_phase_get, ss, &EtherCATSignalsSlots_1channel::handler_get_phase);

//			if (gui.config->get_phase_gain_board_mode() == 0)
//			{
//				connect(ss, &EtherCATSignalsSlots::signal_set_phase, RF_System::Channels->at(i), &RF_Channel::Set_Phase);
//				connect(RF_System::Channels->at(i), &RF_Channel::signal_phase_get, ss, &EtherCATSignalsSlots::handler_get_phase);
//			}
//			else if (gui.config->get_phase_gain_board_mode() == 1)
//			{
//				connect(ss, &EtherCATSignalsSlots::signal_set_PGB_phase, RF_System::Channels->at(i), &RF_Channel::Set_PGB_Phase);
//				connect(RF_System::Channels->at(i), &RF_Channel::signal_PGB_phase_get, ss, &EtherCATSignalsSlots::handler_get_PGB_phase);
//			}

			//Data Logger is a GUI interaction rather than an RF channel interaction. Not supported atm...
//			connect(gui.datalogger, &LoggingClass::signal_datalogging_enable, ss, &EtherCATSignalsSlots::handler_datalogging_enable_get);
//			connect(gui.datalogger, &LoggingClass::signal_datalogging_storage_sufficient, ss, &EtherCATSignalsSlots::handler_datalogging_storage_sufficient);

			//Restart is a GUI interaction rather than an RF channel interaction. Not supported atm...
//			connect(ss, &EtherCATSignalsSlots_1channel::signal_execute_restart_program, &gui, &GUI_1channel::handler_execute_restart_program);

		}

#endif

	}
	else
	{
		stopEtherCATSlave(slave);
		delete in;
		delete out;
		delete ss;
	}

	this->enabled = enabled;
}
